/*
 * QrfeHardwareInfo.cpp
 *
 *  Created on: 02.12.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfeHardwareInfo.h"

#include <QrfeGlobal>
#include <QrfeTrace>
#include <QrfeCRC>

bool qrfe_getCpuId( QString & vendor, QString & brand );
bool qrfe_getVolumeSerialNumber( quint32 &serial );


QByteArray QrfeHardwareInfo::cpuHash()
{
	QString vendor, brand;

	qrfe_getCpuId(vendor, brand);

//	QrfeTrace::trc(0, "CPU - Vendor:       " + vendor);
//	QrfeTrace::trc(0, "CPU - Brand String: " + brand);

    QByteArray hash = QrfeCRC::calcMD5(vendor.toLatin1() + brand.toLatin1());

	return hash;
}

QByteArray QrfeHardwareInfo::hddHash()
{
	quint32 hddserial = 0;

	qrfe_getVolumeSerialNumber(hddserial);

//	QrfeTrace::trc(0, "HDD - Serial:       " + QString("%1").arg((uint)hddserial, 8, 16, QChar('0')) );

	QByteArray result = QrfeGlobal::arrayToQByteArray((int*)&hddserial, 1);

	QByteArray hash = QrfeCRC::calcMD5(result);

	return hash;
}


QByteArray QrfeHardwareInfo::hardwareHash()
{
	QString vendor, brand;
	quint32 hddserial = 0;

	qrfe_getCpuId(vendor, brand);
	qrfe_getVolumeSerialNumber(hddserial);


	QByteArray data;
	//data += vendor.toAscii();		// Leave out vendor, because it is too common.
    data += brand.toLatin1();
	data += QrfeGlobal::arrayToQByteArray((int*)&hddserial, 1);

	return QrfeCRC::calcMD5(data);
}
